#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;

#define sz(x) ((int) (x).size())
#define pb push_back
#define mp make_pair
#define fi first
#define se second

#define NAME "f"

struct edge
{
	int to, cap, flow;
	
	edge(int nto, int nc): to(nto), cap(nc), flow(0) {}
};

const int maxn = 2222;

int n, m, s, t;
vector<edge> edges;
vector<int> g[maxn];
vector<int> from[maxn], to[maxn];
int dist[2][maxn], ptr[maxn], layer[maxn], q[maxn];

void addEdge(int u, int v)
{
	g[u].pb(edges.size());
	edges.pb(edge(v, 1));
	
	g[v].pb(edges.size());
	edges.pb(edge(u, 0));
}

bool bfs(int s, int t)
{
	fill(layer, layer + n, -1);
	int qh = 0, qt = 0;
	layer[s] = 0;
	q[qt++] = s;
	while (qh < qt)
	{
		int v = q[qh++];
		for (int id : g[v])
		{
			if (edges[id].cap - edges[id].flow <= 0 || layer[edges[id].to] != -1) continue;
			layer[edges[id].to] = layer[v] + 1;
			q[qt++] = edges[id].to;
		}
	}
	return layer[t] != -1;
}

void go(vector<int> graph[maxn], int s, int *d)
{
	fill(d, d + n, -1);
	int qh = 0, qt = 0;
	d[s] = 0;
	q[qt++] = s;
	while (qh < qt)
	{
		int v = q[qh++];
		for (int u : graph[v])
		{
			if (d[u] != -1) continue;
			d[u] = d[v] + 1;
			q[qt++] = u;
		}
	}
}

int dfs(int v, int t)
{
	if (v == t) return 1;
	for (; ptr[v] < (int) g[v].size(); ptr[v]++)
	{
		int id = g[v][ptr[v]];
		const edge &e = edges[id];
		if (e.cap - e.flow <= 0 || layer[v] + 1 != layer[e.to]) continue;
		if (dfs(e.to, t))
		{
			edges[id].flow += 1;
			edges[id ^ 1].flow -= 1;
			return 1;
		}
	}
	return 0;
}

int dinic(int s, int t)
{
	int flow = 0;
	while (bfs(s, t))
	{
		fill(ptr, ptr + n, 0);
		while (int pushed = dfs(s, t))
			flow += pushed;
	}
	return flow;
}

bool solve()
{
	scanf("%d%d%d%d", &n, &m, &s, &t);
	if (n == 0 && m == 0 && s == 0 && t == 0) return false;
	--s, --t;
	
	for (int i = 0; i < n; ++i) 
		g[i].clear(), from[i].clear(), to[i].clear();
	edges.clear();

	for (int i = 0; i < m; ++i)
	{
		int a, b;
		scanf("%d%d", &a, &b);
		--a, --b;
		addEdge(a, b);
	}
	int flow = dinic(s, t);
	
	for (int v = 0; v < n; ++v)
		for (int id : g[v])
		{
			if (edges[id].flow == edges[id].cap) continue;
			from[v].pb(edges[id].to);
			to[edges[id].to].pb(v);
		}
	go(from, s, dist[0]);
	go(to, t, dist[1]);

	int ans = flow, cnt = 0;
	for (int v = 0; v < n; ++v)
		for (int id : g[v])
		{
			if (edges[id].cap != 1) continue;
			int u = edges[id].to;
			if (dist[0][u] != -1 && dist[1][v] != -1)
				ans = flow + 1, cnt++;
		}
	printf("%d %d\n", ans, cnt);
	return true;
}

int main()
{
	#ifdef LOCAL
	assert(freopen(NAME ".in", "r", stdin));
	#endif // LOCAL
	while (solve());
	#ifdef LOCAL
	cerr << "Time: " << double(clock()) / CLOCKS_PER_SEC << "\n";
	#endif // LOCAL
	return 0;
}
